import { userLogout } from "@/redux/authSlice";
import Cookies from "js-cookie";

const Time = 2 * 60 * 60 * 1000; // 2 hours
// const Time = 1 * 60 * 1000; // 1 minute (testing)

const handleLogout = (dispatch) => {
  dispatch(userLogout(null));
  Cookies.remove("role");
  Cookies.remove("authToken");
  localStorage.clear();
  localStorage.removeItem("authToken");
};

export const checkSessionExpiry = (authState, dispatch) => {
  if (
    authState.isLoggedIn &&
    !authState.user_verified && 
    authState.loginTime
  ) {
    const currentTime = Date.now();
    if (currentTime - authState.loginTime > Time) {
      handleLogout(dispatch);
    }
  }
};
